'''Завантажувач архіву компоненти на сервер оновлення
    Запуск: python k2update_push.py
    Налаштування:
    ../builder/config/ignore/component_name.txt - список виключень (назва файлу з розширенням або каталогу  з нового рядка)
    ../builder/config/components-list.txt - список компонент
    ../builder/config/token.txt - токен доступу
'''
import requests
import shutil
import zipfile
import os
import json

from k2.k2cfg import K2

# Ваш JWT токен
token_file = '../builder/config/token.txt'
with open(token_file, 'r') as file:
    jwt_token = file.read().strip()  # Зчитуємо токен з файлу і видаляємо зайві пробіли, якщо вони є
# URL СЕРВЕРА ОНОВЛЕНЬ для завантаження файлу
server_url = K2.update_domain + '/k2update/api/save-archive-components-with-tokens/'
#server_url = 'http://127.0.0.1:7654' + '/k2update/api/save-archive-components-with-tokens/'

# конфіги
components_list_file = '../builder/config/components-list.txt'
components_list = []  # Ініціалізуємо пустий список components_list
with open(components_list_file, 'r') as file:
    for line in file:
        component_path = line.strip()  # Видаляємо зайві пробіли та символи нового рядка
        components_list.append(component_path)  # Додаємо компонент до списку components_list


# def copy_files_with_exclusions(comp, comp_name_folder, exclude_files):
#     try:
#         # Copy all files and folders from the component, excluding files listed in exclude_files
#         for root, dirs, files in os.walk(comp):
#             # Remove directories from dirs list if they are in the exclude_files list
#             dirs[:] = [d for d in dirs if os.path.relpath(os.path.join(root, d), comp) not in exclude_files]
#
#             for file in files:
#                 if file not in exclude_files:
#                     src_path = os.path.join(root, file)
#                     dst_path = os.path.join(comp_name_folder, os.path.relpath(src_path, comp))
#                     os.makedirs(os.path.dirname(dst_path), exist_ok=True)
#                     shutil.copy2(src_path, dst_path)
#
#             # Exclude directories listed in exclude_files from further traversal
#             dirs[:] = [d for d in dirs if os.path.join(root, d) not in exclude_files]
#
#     except Exception as e:
#         print(f"An error occurred: {e}")


#цикл по списку компонент
for comp in components_list:
    try:
        # Initialize the list of excluded files for the current component
        exclude_files = []

        # Path to the exclude files list
        exclude_files_file = f"../builder/config/ignore/{os.path.basename(comp)}.txt"

        # Read the exclude files list from the file if it exists
        if os.path.exists(exclude_files_file):
            with open(exclude_files_file, 'r') as file:
                for line in file:
                    exclude_files.append(line.strip())  # Add files to the exclude list

        # Define the archive name matching the last folder
        comp_name = os.path.basename(comp)
        zip_filename = f'../builder/components/{comp_name}.zip'

        # Create a folder named `comp_name` for copying files
        comp_name_folder = f'../builder/components/{comp_name}'
        os.makedirs(comp_name_folder, exist_ok=True)

        #copy_files_with_exclusions(comp, comp_name_folder, exclude_files)
        shutil.copytree(comp, comp_name_folder + f'/{comp_name}', ignore=shutil.ignore_patterns(*exclude_files), dirs_exist_ok=True)

        # Create the archive
        shutil.make_archive(comp_name_folder, 'zip', comp_name_folder)

        # Remove the `comp_name_folder`
        shutil.rmtree(comp_name_folder)

    except Exception as e:
        print(f"An error occurred: {e}")

    # Передайте JWT токен у заголовку Authorization
    headers = {'Authorization': f'Bearer {jwt_token}'}

    # Встановіть ім'я, під яким ви хочете зберегти файл на СЕРВ1
    file_name_on_server = os.path.basename(comp) + '.zip'

    # Створіть об'єкт "файл" для відправки
    files = {'file': (file_name_on_server, open(zip_filename, 'rb'))}
    response = requests.post(server_url, files=files, headers=headers)


    if response.status_code == 200:
        try:
            data = response.json()
            #print(data)
        except json.decoder.JSONDecodeError:
            print("Помилка: Відповідь сервера не є дійсним JSON.")
    else:
        print(f"Помилка відповіді сервера: {response.status_code}.")
    print(response.json())