import os.path
from importlib import import_module
import importlib.util
import sys

from flask_sqlalchemy import SQLAlchemy
import yaml
import logging

from k2.k2upd import components_bp
from k2.k2cfg import K2
from app import app


components = K2.search_comp_names()
print(components)


# Function to register the components with the app
app.register_blueprint(components_bp)
def register_components(app, components):
    '''Функція реєстрації компонент'''
    for component in components:
        try:
            sys.path.append("..")
            module_names = [
                f"cfg.{K2.proj_config}.components.{component}.{component}.views",
                f"components.{component}.{component}.views"
            ]

            found_module_name = None
            module_spec = None
            for module_n in module_names:
                try:
                    module_spec = importlib.util.find_spec(module_n)
                    if module_spec is not None:
                        found_module_name = module_n
                        break
                except Exception as e:
                    if 'cfg' not in str(e):
                        logging.error(f"Error found module {str(e)}")

            if found_module_name is not None:
                try:
                    module = importlib.import_module(found_module_name)
                    blueprint = getattr(module, component)

                    if blueprint.name == 'k2site':
                        login_manager = K2().init_lm(app)

                    if blueprint.name not in app.blueprints:
                        if component == 'k2grid':
                            app.register_blueprint(blueprint, url_prefix="/")
                        else:
                            app.register_blueprint(blueprint, url_prefix=f"/{component}")
                            app.config['BABEL_TRANSLATION_DIRECTORIES'] = K2.babel_translation_directories
                except Exception as e:
                    logging.error(f"Error import module {str(e)} component {component}")
                    print(f"Error importing module for component: {component}")
        except Exception as e:
            logging.error(f"Error import module {str(e)}")


# Call the function to register the components

register_components(app, components)

def unregister_component(app, components):
    '''Функція вимкнення компонент'''
    # Формуємо ім'я модуля на основі назви компоненти
    for component in components:
        module_name = f"components.{component}.{component}.views"
        # Видаляємо blueprint, якщо він є зареєстрованим в додатку
        module = import_module(module_name)
        blueprint = getattr(module, component)
        if blueprint.name in app.blueprints:
            app.blueprints.pop(blueprint.name)

        else:
            pass
            #logging.error(f"Error: Component '{component}' not found or has no blueprint.")

