import redis
import logging
from k2.k2cfg import K2


class RedisInstance:
    _instance = None

    def __new__(cls):
        if cls._instance is None:
            logging.info("Initializing Redis connection...")
            cls._instance = super().__new__(cls)
            cls._instance._init_connection()
        return cls._instance

    def _init_connection(self):
        self.config = K2().init_redis_uri() or {}
        try:
            pool = redis.ConnectionPool(
                **self.config, decode_responses=True, max_connections=10
            )
            self.client = redis.Redis(connection_pool=pool)
            self.client.ping()
            logging.info("Redis connected successfully")
        except redis.RedisError as e:
            logging.error(f"Redis initialization failed: {e}")
            self.client = None

    def get_client(self):
        return self.client
