import yaml
import os
import sys

from flask import session, request, redirect, url_for, jsonify, render_template
import inspect
import logging

class K2Obj:
    name = 'k2obj'
    version = ''
    data_source = ['']
    proj_config = yaml.safe_load(open("../proj.yml"))['proj']
    #db = K2.db
    path_objs = [
        f"../cfg/{proj_config}/k2/{name.lower()}.py",
        f"cfg/{name.lower()}.py",
        f"usr/cfg/{name.lower()}.py"
    ]
    db = None

    def __init__(self):
        self._name_yml = None
        self._name_yml_tree = None
        self._new_buttons = None
        self._name_yml_master = None
        self._send_params = None
        self._send_group_params = None
        self._report_id = None
        self._data_source = None
        self._off_buttons = None
        self._row_selection = None

    @property
    def report_id(self):
        return self._report_id

    @report_id.setter
    def report_id(self, name: str):
        self._report_id = name

    @property
    def row_selection(self):
        return self._row_selection

    @row_selection.setter
    def row_selection(self, name: str):
        self._row_selection = name

    @property
    def name_yml(self):
        """Getter"""
        return self._name_yml

    @name_yml.setter
    def name_yml(self, name: str):
        """Setter method"""
        self._name_yml = name

    @property
    def name_yml_master(self):
        """Getter"""
        return self._name_yml_master

    @name_yml_master.setter
    def name_yml_master(self, name: str):
        """Setter method"""
        self._name_yml_master = name

    @property
    def name_yml_tree(self):
        """Getter"""
        return self._name_yml_tree

    @name_yml_tree.setter
    def name_yml_tree(self, name: str):
        """Setter method"""
        self._name_yml_tree = name

    @property
    def html_file(self):
        """Getter html file"""
        return self._html_file

    @html_file.setter
    def html_file(self, html: str):
        """Setter method"""
        self._html_file = html

    @property
    def new_buttons(self):
        """Getter"""
        return self._new_buttons

    @new_buttons.setter
    def new_buttons(self, name: dict):
        """Setter method"""
        self._new_buttons = name

    @property
    def off_buttons(self):
        """Getter"""
        return self._off_buttons

    @off_buttons.setter
    def off_buttons(self, name: dict):
        """Setter method"""
        self._off_buttons = name

    @property
    def send_params(self):
        """Getter"""
        return self._send_params

    @send_params.setter
    def send_params(self, name: dict):
        """Setter method"""
        self._send_params = name

    @property
    def send_group_params(self):
        """Getter"""
        return self._send_group_params

    @send_group_params.setter
    def send_group_params(self, name: dict):
        """Setter method"""
        self._send_group_params = name

    @property
    def data_source(self):
        """Getter"""
        return self._data_source

    @data_source.setter
    def data_source(self, name: str):
        """Setter method"""
        self._data_source = name

    # def create_names_yml(self, name_yml: str = '', name_yml_tree: str = '', name_yml_master: str = ''):
    #     names_yml = {
    #         'name_yml': name_yml,
    #         'name_yml_tree': name_yml_tree,
    #         'name_yml_master': name_yml_master,
    #
    #     }
    #     return names_yml

    def show_grid(self):
        pass

    def select_grid(self):
        pass


    def content(self):
        pass

    def create_names_yml(self, name_yml: str = '', name_yml_tree: str = '', name_yml_master: str = ''):
        names_yml = {
            'name_yml': name_yml,
            'name_yml_tree': name_yml_tree,
            'name_yml_master': name_yml_master,

        }
        return names_yml


    @staticmethod
    def construct_handbook(names_yml: dict = None,
                           send_params: dict = None,
                           report_id: str = None,
                           new_buttons: dict = None,
                           off_buttons: dict = None,
                           data_source: dict = None,
                           html_file: str = "base-form-grid-template.html",
                           # Змінив дефолтне значення на більш загальне
                           name_yml_form: str = None,
                           send_params_form: dict = None,
                           report_id_form: str = None,
                           data_source_form: dict = None,
                           parent_id_form: str = None,
                           title: str = "",
                           **kwargs):
        """
           Create a form and grid-based handbook with a tree structure and additional grid settings.
           Can render a page even if grid settings (names_yml) or form settings (name_yml_form) are not provided.

           Args:
               names_yml (dict, optional): Dictionary containing YAML file names for grid settings. Expected keys:
                   - 'name_yml_tree' (str): YAML file for tree structure settings.
                   - 'name_yml' (str): YAML file for main grid settings.
                   - 'name_yml_master' (str): YAML file for master grid settings.
               send_params (dict, optional): Parameters to be sent to the grid.
               report_id (str, optional): Report ID for the grid report configuration.
               new_buttons (dict, optional): Dictionary of new buttons to be added to the toolbar.
               off_buttons (dict, optional): Dictionary of buttons to be removed from the toolbar.
               data_source (dict, optional): Data source configuration for the report.
               html_file (str): Name of the HTML file to render the handbook.
               name_yml_form (str, optional): YAML file name for form settings.
               send_params_form (dict, optional): Parameters to be sent to the form.
               report_id_form (str, optional): Report ID for the form report configuration.
               data_source_form (dict, optional): Data source configuration for the form.
               parent_id_form (str, optional): Parent ID for the form configuration.
               title (str, optional): Page title.
               **kwargs: Additional keyword arguments to be passed to the render template.

           Returns:
               Flask Response: Rendered template.

           Raises:
               ImportError: If K2Grid or K2Form components are missing and attempted to be used.
               Exception: For any other errors encountered during the construction of the form or grid.
           """
        K2Grid = None
        K2Form = None
        try:
            from components.k2grid.k2grid.views import K2Grid
        except Exception as ex:
            logging.warning(f"{ex} K2Grid component is missing. Grid functionality will be unavailable.")
        try:
            from components.k2form.k2form.views import K2Form
        except Exception as ex:
            logging.warning(f"{ex} K2Form component is missing. Form functionality will be unavailable.")

        # method = request.method # Змінна method не використовується далі
        try:
            k2form_instance = None  # Перейменовано, щоб уникнути конфлікту з імпортом
            if name_yml_form and K2Form:
                k2form_instance = K2Form(name_yml=name_yml_form)
                if send_params_form is not None:
                    # Метод send_params, ймовірно, не повертає значення, тому кома в кінці не потрібна
                    k2form_instance.send_params(name_yml_form, send_params_form)
                if report_id_form and data_source_form:
                    k2form_instance.report = {
                        'report_id': report_id_form,
                        'data_source': data_source_form,
                    }
                elif report_id_form:
                    k2form_instance.report = {
                        'report_id': report_id_form,
                    }
                k2form_instance.parent_id = parent_id_form
            elif name_yml_form and not K2Form:
                logging.error("K2Form component is missing, but name_yml_form was provided.")

            k2grid_instance = None  # Перейменовано
            if isinstance(names_yml, dict) and K2Grid:
                name_yml_tree = names_yml.get('name_yml_tree')
                name_yml_grid = names_yml.get('name_yml')
                name_yml_master = names_yml.get('name_yml_master')

                if name_yml_tree:
                    k2grid_instance = K2Grid(name_yml=name_yml_tree, type_grid='tree')
                    if name_yml_grid:
                        k2grid_instance.add_grid(name_yml=name_yml_grid)
                elif name_yml_grid:  # Якщо немає дерева, але є основний грід
                    k2grid_instance = K2Grid(name_yml=name_yml_grid)

                # Додаємо майстер-грід, якщо k2grid_instance вже створено або якщо майстер-грід єдиний
                if k2grid_instance and name_yml_master:
                    k2grid_instance.add_grid(name_yml=name_yml_master)
                elif not k2grid_instance and name_yml_master:
                    k2grid_instance = K2Grid(name_yml=name_yml_master)

                # Застосовуємо конфігурації гріда, тільки якщо k2grid_instance успішно ініціалізовано
                if k2grid_instance:
                    if send_params is not None:
                        for send_param_key in send_params:
                            k2grid_instance.send_params(send_param_key, send_params[send_param_key])
                    if new_buttons is not None:
                        for new_button_key in new_buttons:
                            k2grid_instance.add_button_toolbar(new_button_key, new_buttons[new_button_key])
                    if off_buttons is not None:
                        for off_button_key in off_buttons:
                            k2grid_instance.off_button_toolbar(off_button_key, off_buttons[off_button_key])
                    if report_id is not None and data_source is not None:
                        k2grid_instance.report = {
                            'report_id': report_id,
                            'data_source': data_source,
                        }
                    elif report_id is not None:
                        k2grid_instance.report = {
                            'report_id': report_id,
                        }
            elif isinstance(names_yml, dict) and not K2Grid:
                logging.error("K2Grid component is missing, but names_yml was provided.")

            # Завжди намагаємося відрендерити шаблон, передаючи k2grid_instance та k2form_instance,
            # які можуть бути None. Шаблон html_file має це обробляти.
            return render_template(
                template_name_or_list=html_file,
                grid_settings=k2grid_instance,
                form_settings=k2form_instance,
                title=title,
                **kwargs
            )

        except Exception as ex:
            logging.error(f"{ex} form-grid construct error ({html_file})")
            # В разі помилки, все одно намагаємося відрендерити сторінку, передаючи помилку
            return render_template(html_file, error=f'{ex}', title=title, **kwargs)

    @staticmethod
    def select_handbook(names_yml: dict = None,
                        send_params: dict = None, report_id: str = None, new_buttons: dict = None, off_buttons: dict = None,
                        data_source: dict = None, html_file: str = "k2handbook/k2handbook.html",
                        row_selections: str = None, show_tree_grid: bool = None, **kwargs):
        """
        Create a handbook with a tree structure and additional grid settings.

        Args:
            name_yml_tree (str): Name of the YAML file containing tree structure settings.
            names_yml (str): Name of the YAML file containing additional grid settings.
            html_file (str): Name of the HTML file to render the handbook.

        Returns:
            Flask Response: Rendered template with tree structure and grid settings.

        """
        try:
            from components.k2grid.k2grid.views import K2Grid
        except Exception as ex:
            logging.error(f"{ex} K2Grid is missing for correct work")
        try:
            from components.k2form.k2form.views import K2Form
        except Exception as ex:
            logging.error(f"{ex} K2Form is missing for correct work")
        try:
            from k2.components.k2grid.k2grid.utils import send_grid_forms_to_client
        except Exception as ex:
            logging.error(f"{ex} K2Grid is missing for correct work utils")
        method = request.method
        k2grid = None
        if names_yml['name_yml_tree'] != '':
            k2grid = K2Grid(name_yml=names_yml['name_yml_tree'], type_grid='tree')
            if names_yml['name_yml'] != '':
                k2grid.add_grid(name_yml=names_yml['name_yml'])
        if names_yml['name_yml_tree'] == '' and names_yml['name_yml'] != '':
            k2grid = K2Grid(name_yml=names_yml['name_yml'])
        if names_yml['name_yml_master'] != '':
            k2grid.add_grid(name_yml=names_yml['name_yml_master'])
        # if method == 'GET':
        try:
            if send_params is not None:
                for send_param in send_params:
                    k2grid.send_params(send_param, send_params[send_param])
            if new_buttons is not None:
                for new_button in new_buttons:
                    k2grid.add_button_toolbar(new_button, new_buttons[new_button])
            if off_buttons is not None:
                for off_button in off_buttons:
                    k2grid.off_button_toolbar(off_button, off_buttons[off_button])
            if row_selections is not None:
                for row_selection in row_selections:
                    k2grid.set_row_selection(row_selection, row_selections[row_selection])
            if show_tree_grid is not None:
                k2grid.show_tree_grid = show_tree_grid
            if report_id is not None and data_source is not None:
                k2grid.report = {
                    'report_id': report_id,
                    'data_source': data_source,
                }
            elif report_id is not None:
                k2grid.report = {
                    'report_id': report_id,
                }
            if method == 'GET':
                try:
                    from k2.components.k2grid.k2grid.utils import send_grid_forms_to_client
                    message, forms_sent_count, status = send_grid_forms_to_client(k2grid)
                except Exception as ex:
                    logging.error(f"{ex} K2Grid is missing for correct work utils")

                return render_template(template_name_or_list=html_file, grid_settings=k2grid, **kwargs)
        except Exception as ex:
            logging.error(f"{ex} grid is missing for correct work")
            return render_template(html_file, error=f'{ex}')
        if method == 'POST':
            # k2grid = K2Grid(name_yml=names_yml['name_yml_tree'], type_grid='tree')
            # k2grid.add_grid(name_yml=names_yml['name_yml'])
            # k2grid.send_params('k2nomenclature_group', send_params['k2nomenclature_group'])
            # k2grid.send_params('k2nomenclature', send_params['k2nomenclature'])
            k2grid.select_func = "True"
            k2grid.event_name = 'grid_select_item'

            # grid_settings = {
            #     'domain': k2grid.domain,
            #     'template': k2grid.template,
            #     'selectFunc': k2grid.select_func,
            #     'selectFuncName': k2grid.event_name,
            #     'language': k2grid.language
            # }
            grid_settings = k2grid.get_properties()
            if names_yml['name_yml_tree'] != '':
                grid_settings['name'] = names_yml['name_yml_tree']
                if names_yml['name_yml'] != '':
                    grid_settings['nameMaster'] = names_yml['name_yml']
            elif names_yml['name_yml_tree'] == '' and names_yml['name_yml'] != '':
                grid_settings['name'] = names_yml['name_yml']
            if names_yml['name_yml_master'] != '':
                grid_settings['nameDetail'] = names_yml['name_yml_master']
            try:
                message, forms_sent_count, status = send_grid_forms_to_client(k2grid)
            except Exception as e:
                pass
            return jsonify({
                'message': 'Grid select successfully',
                'grid_settings': grid_settings,
                'status': 'success'
            })

    # @staticmethod
    # def create_grid(name_yml: str, html_file: str, new_buttons: dict = None):
    #     """
    #     Create handbook with standard grid settings.
    #
    #     Args:
    #         name_yml (str): Path to the YAML file containing grid settings.
    #         html_file (str): Name of the HTML file to render the handbook.
    #
    #     Returns:
    #     Flask Response: Rendered template with grid settings.
    #     """
    #     try:
    #         from components.k2grid.k2grid.views import K2Grid
    #     except Exception as ex:
    #         logging.error(f"{ex} K2Grid is missing for correct work")
    #     try:
    #         from components.k2form.k2form.views import K2Form
    #     except Exception as ex:
    #         logging.error(f"{ex} K2Form is missing for correct work")
    #     try:
    #         k2grid = K2Grid(name_yml=name_yml)
    #         if new_buttons is not None:
    #             k2grid.add_button_toolbar(name_yml, new_buttons)
    #         return render_template(template_name_or_list=html_file, grid_settings=k2grid)
    #
    #     except Exception as ex:
    #         logging.error(f"{ex}")
    #         return render_template(html_file, error=f"{ex}")
    #
    #
    # @staticmethod
    # def create_tree_grid(name_yml_tree: str, name_yml: str, html_file: str):
    #     """
    #     Create a handbook with a tree structure and additional grid settings.
    #
    #     Args:
    #         name_yml_tree (str): Name of the YAML file containing tree structure settings.
    #         name_yml (str): Name of the YAML file containing additional grid settings.
    #         html_file (str): Name of the HTML file to render the handbook.
    #
    #     Returns:
    #         Flask Response: Rendered template with tree structure and grid settings.
    #
    #     """
    #     try:
    #         k2grid = K2Grid(name_yml=name_yml_tree, type_grid='tree')
    #         k2grid.add_grid(name_yml=name_yml)
    #         return render_template(template_name_or_list=html_file, grid_settings=k2grid)
    #     except Exception as ex:
    #         logging.error(f"{ex} grid is missing for correct work")
    #         return render_template(html_file, error=f'{ex}')
    #
    #
    # @staticmethod
    # def create_master_grid(name_yml, html_file, name_yml_master):
    #     try:
    #         k2grid = K2Grid(name_yml=name_yml)
    #         k2grid.add_grid(name_yml=name_yml_master)
    #         return render_template(template_name_or_list=html_file,
    #                                grid_settings=k2grid)
    #     except Exception as ex:
    #         logging.error(f"{ex}")
    #         return render_template(html_file, error=f"{ex}")


    # Отримуємо значення для розширення поточного класу
    @classmethod
    def get_calling_class_name(cls):
        '''Отримання імені класу, з якого викликається метод'''
        frame = inspect.stack()[1]
        calling_class = frame[0].f_locals.get('self', None)
        if calling_class:
            return calling_class.__class__.__name__
        return None


    #@staticmethod
    def search_class_prop(path_objs):
        '''Пошук властивостей для розширення класу'''
        code_str = None
        for path_obj in path_objs:
            if os.path.exists(path_obj):
                with open(path_obj, 'r') as file:
                    code_str = file.read()
                break  # Виходимо з циклу, якщо знайдено файл
        else:
            sys.exit()  # Завершуємо процес, якщо жоден файл не знайдено
        return code_str


    code_str = search_class_prop(path_objs)
    # @staticmethod
    # def ins_class_prop(code_str):
    try:
        exec(code_str)
    except Exception as e:
        print(f"Error in K2obj {e}")
        sys.exit()

    #ins_class_prop(code_str)

    # code_str = None
    # for path_obj in path_objs:
    #     if os.path.exists(path_obj):
    #         with open(self.path_obj, 'r') as file:
    #             code_str = file.read()
    #         break  # Виходимо з циклу, якщо знайдено файл
    # else:
    #     sys.exit()  # Завершуємо процес, якщо жоден файл не знайдено

   #Вставляємо отримані значення


#print(K2Obj.__dict__)