import logging
import os
from flask_login import LoginManager, current_user
import json
from datetime import datetime
import datetime
from sqlalchemy.orm.state import InstanceState
from sqlalchemy.exc import IntegrityError
from sqlalchemy import create_engine, MetaData, Table, select
from sqlalchemy.orm import sessionmaker
import requests
import shutil
import zipfile
import os
import decimal




from .k2obj import K2Obj


class K2Datasync(K2Obj):
    '''
    клас формування і передачі/отримання даних

     через сервер оновлення k2update
     '''
    name = 'k2datasync'
    def __init__(self, *args, **kwargs):
        super().__init__()

    def __serialize_model_instance(self, instance):
        """Serialize SQLAlchemy model instance to a dictionary."""
        serialized_instance = {}

        for column in instance.__table__.columns:
            value = getattr(instance, column.name)
            if value is not None and not isinstance(value, InstanceState):
                # Виключити значення None (null) та InstanceState
                if isinstance(value, datetime):
                    serialized_instance[column.name] = value.isoformat()
                else:
                    serialized_instance[column.name] = value
        return serialized_instance


    def __deserialize_model_instance(self, model, data):
        '''Десеріалізація та додавання до бази даних'''
        from app import app, db
        with app.app_context():

            for record in data:
                for table_name, rows in record.items():
                    for row in rows:
                        new_instance = model(**row)
                        db.session.add(new_instance)
                        try:
                            db.session.commit()
                        except IntegrityError:
                            # Якщо виникає конфлікт унікальності (наприклад, дублікат запису)
                            # можна обробити цю помилку, якщо це потрібно
                            db.session.rollback()


    def __save_model_data(self, model, filename):
        '''Збереження даних моделі у JSON-файл'''
        data = [{model.__tablename__: [self.serialize_model_instance(row) for row in model.query.all()]}]

        with open(filename, 'w') as json_file:
            json.dump(data, json_file, indent=2)


    def __save_table_data(self):
        '''Збереження даних з таблиць БД  у JSON-файл'''

        from app import app, db
        from .k2upd import K2Upd
        try:
            metadata = MetaData()
            conn = db.engine.connect()

            table_data = Table('k2tables', metadata, autoload_with=db.engine)
            query = select(table_data).where(table_data.c.sync_data == '1')
            result = conn.execute(query)
            # print(result)

            data_table = []
            data_table_reports = ['k2reports', 'k2reports_tree_categories']
            for row in result:
                row_data = {}
                for i, value in enumerate(row):
                    column = list(result.keys())[i]  #
                    row_data[column] = value
                    if column == 'table_mainname':
                        data_table.append(value)
            #print(data)
            for table_name in data_table:
                try:
                    table_data = Table(table_name, metadata, autoload_with=db.engine)
                    query = table_data.select()
                    result = conn.execute(query)
                    # print(result)
                    data = []
                    for row in result:
                        row_data = {}
                        for i, value in enumerate(row):
                            column = list(result.keys())[i]  #
                            if isinstance(value, datetime.datetime):
                                row_data[column] = value.isoformat()
                            elif isinstance(value, datetime.date):
                                row_data[column] = value.isoformat()
                            elif isinstance(value, decimal.Decimal):
                                row_data[column] = str(value)  # Конвертуємо Decimal у рядок
                            else:
                                row_data[column] = value

                        data.append(row_data)
                    data_path = f'../data/k2_cloud_erp/export/handbooks/{table_name}.json'
                    os.makedirs(os.path.dirname(data_path), exist_ok=True)
                    with open(data_path, 'w') as json_file:
                        json.dump(data, json_file, indent=2)
                    K2Upd.save_sync_log_data(component_data_id=table_name,
                                             component_data_type_id='handbooks',
                                             component_data_file=data_path,
                                             sync_status='Success',
                                             sync_error='-',
                                             type_sync = 'export'
                                             )

                    if table_name == 'k2reports' or table_name == 'k2reports_tree_categories':
                        data_path_rep = f'../data/k2_cloud_erp/export/reports/{table_name}.json'
                        os.makedirs(os.path.dirname(data_path_rep), exist_ok=True)
                        with open(data_path_rep, 'w') as json_file:
                            json.dump(data, json_file, indent=2)


                except Exception as e:
                    logging.error(f'Error copy k2reports {e}')
                    K2Upd.save_sync_log_data(component_data_id=table_name,
                                             component_data_type_id='handbooks',
                                             component_data_file=data_path,
                                             sync_status='Error',
                                             sync_error=str(e),
                                             type_sync='export'
                                             )
            data_path_setup_reports = f'../data/k2_cloud_erp/export/reports/setup.json'
            data_setup_report = {'name': 'k2report', 'data': {"handbooks": data_table_reports}}
            with open(data_path_setup_reports, 'w') as json_file:
                json.dump(data_setup_report, json_file, indent=2)

            data_path_setup = f'../data/k2_cloud_erp/export/handbooks/setup.json'
            #print(subclass.export_data)
            data_setup = {'name': 'k2handbook', 'data': {"handbooks":  data_table } }
            with open(data_path_setup, 'w') as json_file:
                json.dump(data_setup, json_file, indent=2)
        except Exception as e:
            logging.error(f"Error copy data to tables {e}")


    def __save_table_data_comp(self):
        '''Збереження даних з таблиць БД  у JSON-файл з компонент'''
        from app import app, db
        metadata = MetaData()
        conn = db.engine.connect()



        for subclass in K2Obj.__subclasses__():
            if hasattr(subclass, 'export_data'):
                # Витягнення всіх даних з таблиці
                for table_name in subclass.export_data['handbooks']:
                    try:
                        table_data = Table(table_name, metadata, autoload_with=db.engine)
                        query = table_data.select()
                        result = conn.execute(query)
                        #print(result)
                        data = []
                        for row in result:
                            row_data = {}
                            for i, value in enumerate(row):
                                column = list(result.keys())[i]  #
                                if isinstance(value, datetime.datetime):
                                    row_data[column] = value.isoformat()
                                elif isinstance(value, datetime.date):
                                    row_data[column] = value.isoformat()
                                else:
                                    row_data[column] = value

                            data.append(row_data)
                        data_path = f'../data/k2_cloud_erp/export/{subclass.__name__.lower()}/{table_name}.json'
                        os.makedirs(os.path.dirname(data_path), exist_ok=True)
                        with open(data_path, 'w') as json_file:
                            json.dump(data, json_file, indent=2)
                        data_path_setup = f'../data/k2_cloud_erp/export/{subclass.__name__.lower()}/setup.json'
                        #print(subclass.export_data)
                        data_setup = {'name': subclass.__name__.lower(), 'data': subclass.export_data }
                        with open(data_path_setup, 'w') as json_file:
                            json.dump(data_setup, json_file, indent=2)
                    except Exception as e:
                        logging.info(f'Error save table data {e}')


    def __save_reports_comp(self):
        data_path_root = '../data/k2_cloud_erp/report'
        data_path = '../data/k2_cloud_erp/export/k2report'
        try:
            shutil.copytree(data_path_root, data_path, dirs_exist_ok=True)
        except FileExistsError as e:
           logging.error(f'save_reports {e}')
        except Exception as e:
            logging.error(f'save_reports {e}')


    def __save_reports(self):

        from .k2upd import K2Upd
        data_path_root = '../data/k2_cloud_erp/report'
        data_path = '../data/k2_cloud_erp/export/reports'
        data_path_rep = f'../data/k2_cloud_erp/export/reports/k2reports.json'

        # Читання даних з файлу setup.json
        try:
            with open(data_path_rep, 'r') as setup_json_file:
                reporstlist = json.load(setup_json_file)
        except Exception as e:
            reporstlist = None
            logging.error(f'save_reports {e}')
        if reporstlist:
            for  report in reporstlist:
               try:
                    component_data_file = report['file_name']
                    # shutil.copytree(data_path_import, data_path_root, dirs_exist_ok=True)
                    source_path = os.path.join(data_path_root, component_data_file)
                    target_path = os.path.join(data_path, component_data_file)
                    shutil.copy(source_path, target_path)

                    check_result = True
                    K2Upd.save_sync_log_data(component_data_id=report['report_name'],
                                             component_data_type_id='reports',
                                             component_data_file=component_data_file,
                                             sync_status='Success',
                                             sync_error='-',
                                             type_sync='export'
                                             )
               except Exception as e:
                   logging.error(f'save_reports {e}')
                   K2Upd.save_sync_log_data(component_data_id=report['report_name'],
                                            component_data_type_id='reports',
                                            component_data_file=component_data_file,
                                            sync_status='Error',
                                            sync_error=str(e),
                                            type_sync='export'
                                            )


    def __save_translates(self):

        from .k2upd import K2Upd
        try:
            from components.k2adm.k2adm.models import K2CompTransl
            from app import db
            from .k2cfg import K2
            data_path_translates = f'../data/k2_cloud_erp/export/translates/setup-lang.json'

            # Перевірка існування файлу
            if not os.path.exists(data_path_translates):
                # Створення пустого списку або інших даних
                translates_list = []
                # Запис даних у файл
                try:
                    with open(data_path_translates, 'w') as setup_json_file:
                        json.dump(translates_list, setup_json_file)
                except Exception as e:
                    logging.error(f'Помилка при створенні файлу: {e}')
            translates_list = []
            # Session = sessionmaker(bind=db.engine)
            # session = Session()
            component_transl = db.session.query(K2CompTransl).filter_by(sync_data='1', active='1').all()
            for component in component_transl:
                data_lang_translates = []
                for lang in K2.get_active_lang_list():
                    data_lang_translates.append(lang)
                    component_name = component.comp_transl_id
                    data_path = f'../data/k2_cloud_erp/export/translates/{component_name}/languages/{lang}/LC_MESSAGES/'
                    if not os.path.exists(data_path):
                        os.makedirs(data_path)
                    lang_path_root_mo = f'components/{component_name}/{component_name}/languages/{lang}/LC_MESSAGES/messages.mo'
                    if os.path.exists(lang_path_root_mo):
                        shutil.copy(lang_path_root_mo, data_path)
                    lang_path_root_po = f'components/{component_name}/{component_name}/languages/{lang}/LC_MESSAGES/messages.po'
                    if os.path.exists(lang_path_root_po):
                        shutil.copy(lang_path_root_po, data_path)
                data_setup_lang = {'name': component.comp_transl_name, 'data': {"translates": data_lang_translates}}
                translates_list.append(data_setup_lang)
                with open(data_path_translates, 'w') as json_file:
                    json.dump(translates_list, json_file, indent=2)
        except Exception as e:
            logging.error(f'save_translates {e}')


    def upload_data_k2update_comp(self):
        '''Завантаження даних на сервер k2update по компонентах'''
        # Ваш JWT токен
        token_file = '../builder/config/token.txt'
        with open(token_file, 'r') as file:
            jwt_token = file.read().strip()  # Зчитуємо токен з файлу і видаляємо зайві пробіли, якщо вони є
        # URL СЕРВЕРА ОНОВЛЕНЬ для завантаження файлу
        from .k2cfg import K2
        server_url = f'{K2.update_domain}k2update/api/save-archive-data-with-tokens/'

        # формування json файлів з даних з БД
        self.__save_table_data_comp()
        # формування репорртів для вілправки
        self.__save_reports_comp()
        # цикл по компонентах
        export_path = '../data/k2_cloud_erp/export'
        for subclass in K2Obj.__subclasses__():
            try:
                data_name = subclass.__name__.lower()
                data_folder = os.path.join(export_path, data_name)
                if os.path.exists(data_folder):
                    zip_filename = f'{export_path}/{data_name}.zip'
                    # Відкриваємо файл архіву для запису
                    with zipfile.ZipFile(zip_filename, 'w', zipfile.ZIP_DEFLATED) as zipf:
                        # Рекурсивно додаємо всю папку `comp_name` в архів
                        for foldername, subfolders, filenames in os.walk(data_folder):
                            for filename in filenames:
                                filepath = os.path.join(foldername, filename)
                                arcname = os.path.relpath(filepath, data_folder)
                                zipf.write(filepath, arcname)
                            zip_filename_send = f'{export_path}/send/{data_name}.zip'
                            # # Перевірка існування папки перед копіюванням
                            if os.path.exists(zip_filename):
                                shutil.move(zip_filename, zip_filename_send)
                            # # Видалення папки `comp_name`
                            # shutil.rmtree(comp_name_folder)

                # Передайте JWT токен у заголовку Authorization
                headers = {'Authorization': f'Bearer {jwt_token}'}

                # Встановіть ім'я, під яким ви хочете зберегти файл на сервері
                file_name_on_server = os.path.basename(zip_filename_send)
                #
                # # Створіть об'єкт "файл" для відправки
                files = {'file': (file_name_on_server, open(zip_filename_send, 'rb'))}
                response = requests.post(server_url, files=files, headers=headers)
                #
                if response.status_code == 200:
                    try:
                        data = response.json()
                        # print(data)
                    except json.decoder.JSONDecodeError:
                        logging.error("Помилка: Відповідь сервера не є дійсним JSON.")
                else:
                    logging.error(f"Помилка відповіді сервера: {response.status_code}.")
                # print(response.json())

            except Exception as ex:
                logging.error(f'Помилка створення архіву {ex}')
                continue


    def upload_data_k2update(self):
        '''Завантаження даних на сервер k2update'''
        # Ваш JWT токен
        token_file = '../builder/config/token.txt'
        with open(token_file, 'r') as file:
            jwt_token = file.read().strip()  # Зчитуємо токен з файлу і видаляємо зайві пробіли, якщо вони є
        # URL СЕРВЕРА ОНОВЛЕНЬ для завантаження файлу
        from .k2cfg import K2
        server_url = f'{K2.update_domain}k2update/api/save-archive-data-with-tokens/'


        # #формування json файлів з даних з БД
        self.__save_table_data()
        # #формування репорртів для вілправки
        self.__save_reports()
        # формування пеекладів для відправки
        self.__save_translates()
        # # папка для експорту
        export_path = '../data/k2_cloud_erp/export'

        from app import app, db

        metadata = MetaData()
        conn = db.engine.connect()

        table_data = Table('k2sync_data_type', metadata, autoload_with=db.engine)
        query = table_data.select()
        result = conn.execute(query)
        # print(result)
        data_table = []
        for row in result:
            row_data = {}
            for i, value in enumerate(row):
                column = list(result.keys())[i]  #
                row_data[column] = value
                if column == 'sync_data_type_id':
                    data_table.append(value)

        for group_type in data_table:
            try:
                data_name = group_type.lower()
                data_folder = os.path.join(export_path, data_name)
                if os.path.exists(data_folder):
                    zip_filename = f'{export_path}/{data_name}.zip'
                    # Відкриваємо файл архіву для запису
                    with zipfile.ZipFile(zip_filename, 'w', zipfile.ZIP_DEFLATED) as zipf:
                        # Рекурсивно додаємо всю папку `comp_name` в архів
                        for foldername, subfolders, filenames in os.walk(data_folder):
                            for filename in filenames:
                                filepath = os.path.join(foldername, filename)
                                arcname = os.path.relpath(filepath, data_folder)
                                zipf.write(filepath, arcname)
                            zip_filename_send = f'{export_path}/send/{data_name}.zip'
                            zip_filename_path = f'{export_path}/send/'
                            # # Перевірка існування папки перед копіюванням
                            if not os.path.exists(zip_filename_path):
                                try:
                                   os.makedirs(zip_filename_path)
                                except Exception as e:
                                    logging.error(f'Помилка при створенні файлу: {e}')
                            if os.path.exists(zip_filename):
                                shutil.move(zip_filename, zip_filename_send)
                            # # Видалення папки `comp_name`
                            # shutil.rmtree(comp_name_folder)

                # Передайте JWT токен у заголовку Authorization
                headers = {'Authorization': f'Bearer {jwt_token}'}

                # Встановіть ім'я, під яким ви хочете зберегти файл на сервері
                file_name_on_server = os.path.basename(zip_filename_send)
                #
                # # Створіть об'єкт "файл" для відправки
                files = {'file': (file_name_on_server, open(zip_filename_send, 'rb'))}
                response = requests.post(server_url, files=files, headers=headers)
                #
                if response.status_code == 200:
                    try:
                        data = response.json()
                        # print(data)
                    except json.decoder.JSONDecodeError:
                        logging.error("Помилка: Відповідь сервера не є дійсним JSON.")
                else:
                    logging.error(f"Помилка відповіді сервера: {response.status_code}.")
                #print(response.json())

                conn.close()

            except Exception as ex:
                logging.error(f'Помилка створення архіву {ex}')
                continue
            finally:
                conn.close()



    #
    #
    # def import_reference_books(self):
    #     '''Імпорт даних в довідник'''
    #
    #     data_ = [
    #         {'k2handbooks': {'K2City'}},
    #         {'k2site': {'K2roles'}},
    #     ]
    #
    #     from components.k2site.k2site.models import K2roles
    #     with open('../data/k2site/k2roles.json', 'r') as json_file:
    #         data = json.load(json_file)
    #         model = K2roles
    #         self.deserialize_model_instance(model, data)
    # #
    #
    # def upload_data_reference_reports(self):
    #     '''передача звітів'''
    #     data_ = [
    #         {'k2reports': {''}},
    #     ]
    #
    #
    #     #передача reports
    #
    #
    #     #передача налаштувань


