#!/bin/bash

# Отримуємо параметри
for arg in "$@"; do
  case $arg in
    --port=*)
      port="${arg#*=}"
      ;;
    --proj=*)
      proj="${arg#*=}"
      ;;
    *)
      # Інші параметри (якщо потрібно обробити)
      ;;
  esac
done

directory="K2CloudERP"

if [ -d "$directory" ]; then
  echo "Директорія існує."
  cd K2CloudERP
  chmod 754 run.sh
  if [ -n "$port" ] && [ -n "$proj" ]; then
    bash run.sh --port=$port --proj=$proj
  elif [ -n "$port" ]; then
    bash run.sh --port=$port --proj='k2'
  elif [ -n "$proj" ]; then
    bash run.sh --port=7654 --proj=$proj
  else
    bash run.sh --port=7654 --proj='k2'
  fi
else
  echo "Директорія не існує."
  tar -xzvf K2CloudERP-2.5.1.79.tar.gz
  cd K2CloudERP
  chmod 754 first_run.sh
  bash first_run.sh
  chmod 754 run.sh
  if [ -n "$port" ]; then
    bash run.sh --port=$port
  else
    bash run.sh --port=7654
  fi
fi

